<?php
header("Content-Type: application/json; charset=UTF-8");
include('../config/db.php');

if (!isset($_GET['category_id'])) {
    echo json_encode(["error" => "category_id is required"]);
    exit;
}

$category_id = intval($_GET['category_id']);

// Query books for this category
$sql = "SELECT books.*, categories.name AS category_name 
        FROM books 
        JOIN categories ON books.category_id = categories.id 
        WHERE books.category_id = $category_id 
        ORDER BY books.id DESC";

$result = $conn->query($sql);

$books = [];
while ($row = $result->fetch_assoc()) {
    $book = [
        "id" => $row['id'],
        "category_id" => $row['category_id'],
        "category_name" => $row['category_name'],
        "name" => $row['name'],
        "title" => $row['title'],
        "description" => $row['description'],
        "icon_url" => $row['icon_url'],
        "feature_image_url" => $row['feature_image_url'],
        "urls" => json_decode($row['urls'], true)
    ];
    $books[] = $book;
}

echo json_encode(["status" => "success", "count" => count($books), "books" => $books], JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
