<?php
session_start();
include('config/db.php');

// Allow only logged-in superadmin
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$username = $_SESSION['username'];
$userCheck = $conn->query("SELECT * FROM admin_users WHERE username = '$username' AND role = 'superadmin'");

if ($userCheck->num_rows === 0) {
    echo "Access denied: Only super admins can view this page.";
    exit;
}

// Handle approval
if (isset($_GET['approve'])) {
    $uid = intval($_GET['approve']);
    $conn->query("UPDATE admin_users SET is_approved = 1 WHERE id = $uid");
    header("Location: approve_users.php");
    exit;
}

$result = $conn->query("SELECT * FROM admin_users WHERE is_approved = 0 ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Approve Users</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-4">
    <h3>🛂 Pending Admin Approvals</h3>

    <?php if ($result->num_rows === 0): ?>
        <div class="alert alert-success mt-3">No pending registrations.</div>
    <?php else: ?>
        <table class="table table-bordered mt-3">
            <thead>
                <tr>
                    <th>ID</th><th>Username</th><th>Registered At</th><th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while ($row = $result->fetch_assoc()): ?>
                    <tr>
                        <td><?= $row['id'] ?></td>
                        <td><?= htmlspecialchars($row['username']) ?></td>
                        <td><?= $row['created_at'] ?></td>
                        <td>
                            <a href="approve_users.php?approve=<?= $row['id'] ?>" 
                               class="btn btn-success btn-sm"
                               onclick="return confirm('Approve this user?')">Approve</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    <?php endif; ?>
</div>
</body>
</html>
