<?php
session_start();
include('config/db.php');

if (isset($_SESSION['admin_logged_in']) && $_SESSION['admin_logged_in']) {
    if ($_SESSION['role'] === 'superadmin') {
        header('Location: superadmin_index.php');
    } else {
        header('Location: index.php');
    }
    exit;
}

$error = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $conn->real_escape_string($_POST['username']);
    $password = $_POST['password'];

    $result = $conn->query("SELECT * FROM admin_users WHERE username='$username' AND is_approved=1 AND is_active=1");

    if ($result->num_rows === 1) {
        $user = $result->fetch_assoc();

        if (password_verify($password, $user['password'])) {
            $_SESSION['admin_logged_in'] = true;
            $_SESSION['username'] = $username;
            $_SESSION['role'] = $user['role']; // superadmin or admin

            // Redirect based on role
            if ($user['role'] === 'superadmin') {
                header('Location: superadmin_index.php');
            } else {
                header('Location: index.php');
            }
            exit;

        } else {
            $error = "Incorrect password.";
        }
    } else {
        $error = "User not approved, inactive, or does not exist.";
    }
}
?>
<!DOCTYPE html>
<html>
<head>
    <title>Admin Login</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
<div class="container mt-5" style="max-width: 400px;">
    <h3 class="text-center mb-4">🔐 Admin Login</h3>

    <?php if ($error): ?>
        <div class="alert alert-danger"><?= $error ?></div>
    <?php endif; ?>

    <form method="POST">
        <input type="text" name="username" placeholder="Username" class="form-control mb-3" required />
        <input type="password" name="password" placeholder="Password" class="form-control mb-3" required />
        <button class="btn btn-primary w-100">Login</button>
    </form>

    <p class="text-center mt-3 text-muted" style="font-size: 0.9rem;">
        Need access? <a href="register.php">Request registration</a>
    </p>
</div>
</body>
</html>
