<?php
session_start();
include('config/db.php');

// Only allow logged-in superadmin
if (!isset($_SESSION['admin_logged_in']) || !$_SESSION['admin_logged_in']) {
    header('Location: login.php');
    exit;
}

$username = $_SESSION['username'];
$userCheck = $conn->query("SELECT * FROM admin_users WHERE username = '$username' AND role = 'superadmin'");
if ($userCheck->num_rows === 0) {
    echo "Access denied: Only superadmins can view this page.";
    exit;
}

// === Handle actions ===
if (isset($_GET['action']) && isset($_GET['id'])) {
    $uid = intval($_GET['id']);
    $user = $conn->query("SELECT * FROM admin_users WHERE id = $uid")->fetch_assoc();

    if ($user && $user['role'] !== 'superadmin') {
        switch ($_GET['action']) {
            case 'approve':
                $conn->query("UPDATE admin_users SET is_approved = 1 WHERE id = $uid");
                break;
            case 'disapprove':
                $conn->query("UPDATE admin_users SET is_approved = 0 WHERE id = $uid");
                break;
            case 'activate':
                $conn->query("UPDATE admin_users SET is_active = 1 WHERE id = $uid");
                break;
            case 'inactivate':
                $conn->query("UPDATE admin_users SET is_active = 0 WHERE id = $uid");
                break;
            case 'delete':
                $conn->query("DELETE FROM admin_users WHERE id = $uid");
                break;
        }
    }
    header("Location: superadmin_index.php");
    exit;
}

// Exclude superadmin from the listing
$result = $conn->query("SELECT * FROM admin_users WHERE role != 'superadmin' ORDER BY created_at DESC");
?>
<!DOCTYPE html>
<html>
<head>
    <title>Super Admin Panel</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <style>
        .nav-link-box {
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.05);
            transition: 0.3s;
        }
        .nav-link-box:hover {
            transform: translateY(-4px);
            box-shadow: 0 8px 16px rgba(0, 0, 0, 0.1);
        }
    </style>
</head>
<body>
<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3>🛡️ Super Admin Dashboard</h3>
        <a href="logout.php" class="btn btn-outline-danger btn-sm">Logout</a>
    </div>

    <!-- Admin Functionalities -->
    <div class="row g-3 mb-4">
        <div class="col-md-4">
            <a href="categories.php" class="text-decoration-none">
                <div class="p-3 bg-white text-center nav-link-box">
                    <h5>📁 Manage Categories</h5>
                    <p class="text-muted">Add, edit, delete categories</p>
                </div>
            </a>
        </div>
        <div class="col-md-4">
            <a href="books.php" class="text-decoration-none">
                <div class="p-3 bg-white text-center nav-link-box">
                    <h5>📖 Manage Books</h5>
                    <p class="text-muted">Add, edit, delete books</p>
                </div>
            </a>
        </div>
        <div class="col-md-4">
            <a href="register.php" class="text-decoration-none">
                <div class="p-3 bg-white text-center nav-link-box">
                    <h5>➕ Add New Admin</h5>
                    <p class="text-muted">Register a new admin</p>
                </div>
            </a>
        </div>
    </div>

    <h4 class="mb-3">👥 Manage Users (Admin Only)</h4>
    <table class="table table-bordered">
        <thead class="table-light">
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>Role</th>
                <th>Approved</th>
                <th>Active</th>
                <th>Created At</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($user = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= $user['id'] ?></td>
                    <td><?= htmlspecialchars($user['username']) ?></td>
                    <td><?= $user['role'] ?></td>
                    <td>
                        <?= $user['is_approved'] ? '✅' : '❌' ?>
                        <a href="?action=<?= $user['is_approved'] ? 'disapprove' : 'approve' ?>&id=<?= $user['id'] ?>" class="btn btn-sm btn-link">
                            <?= $user['is_approved'] ? 'Disapprove' : 'Approve' ?>
                        </a>
                    </td>
                    <td>
                        <?= $user['is_active'] ? '🟢' : '🔴' ?>
                        <a href="?action=<?= $user['is_active'] ? 'inactivate' : 'activate' ?>&id=<?= $user['id'] ?>" class="btn btn-sm btn-link">
                            <?= $user['is_active'] ? 'Inactivate' : 'Activate' ?>
                        </a>
                    </td>
                    <td><?= $user['created_at'] ?></td>
                    <td>
                        <a href="?action=delete&id=<?= $user['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this user?')">Delete</a>
                    </td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>

</div>
</body>
</html>
